#!/bin/sh

ACTIVE_DIR=/opt/fqlink
SERVICE_ACTIVE_DIR=/lib/systemd/system
BACKUP_DIR=/media/service/fqlink_backup
SERVICE_BACKUP_DIR=${BACKUP_DIR}/service
UPGRADE_STATUS_FILE=upgrade_status
UPGRADE_TYPE_FILE=upgrade_type
UPGRADE_FLAG=${ACTIVE_DIR}/${UPGRADE_STATUS_FILE}
UPGRADE_TYPE=${ACTIVE_DIR}/${UPGRADE_TYPE_FILE}
CRC_FILE=sha1.txt
BACKUP_CRC_FILE=${BACKUP_DIR}/${CRC_FILE}
TYPE="all"

if [ -n "$1" ]; then
    TYPE="$1"
fi

echo "Create backup: reason is '${TYPE}' upgrade"
echo "${TYPE}" >> ${UPGRADE_TYPE}

if [ -f "${UPGRADE_FLAG}" ]; then
    STATUS=`cat ${UPGRADE_FLAG}`
    if [ "validate" == ${STATUS} ]; then
        echo "FQLINK backup is already created"
        exit 0
    fi
fi

echo "Start of FQLINK backup creation"
echo "creating" > ${UPGRADE_FLAG}

# Create backup directories if it doesn't exist
if [ ! -d "${BACKUP_DIR}" ]; then
    echo "Initial creation of backup folder '${BACKUP_DIR}'"
    mkdir ${BACKUP_DIR}

    if [ ! -d "${SERVICE_BACKUP_DIR}" ]; then
        echo "Initial creation of backup folder '${SERVICE_BACKUP_DIR}'"
        mkdir ${SERVICE_BACKUP_DIR}
    fi
else
    echo "Cleanup previous backup in folder '${BACKUP_DIR}'"
    rm -rf ${BACKUP_DIR}/*
    mkdir ${SERVICE_BACKUP_DIR}
fi

echo "Copy existing files to backup directory '${BACKUP_DIR}'"
cp -R ${ACTIVE_DIR}/* ${BACKUP_DIR}/
# and exclude runtime files
rm -f ${BACKUP_DIR}/can_app/*.txt ${BACKUP_DIR}/can_app/*.db
rm -f ${BACKUP_DIR}/${UPGRADE_STATUS_FILE}
# copy service files
cp ${SERVICE_ACTIVE_DIR}/fqlink.service ${SERVICE_BACKUP_DIR}/
cp ${SERVICE_ACTIVE_DIR}/fqlink-backup.service ${SERVICE_BACKUP_DIR}/
cp ${SERVICE_ACTIVE_DIR}/iotagent.service ${SERVICE_BACKUP_DIR}/
cp ${SERVICE_ACTIVE_DIR}/fq4000.service ${SERVICE_BACKUP_DIR}/

# calculate CRC of backup contents
rm -f sha*.txt
find ${BACKUP_DIR} -type f  -not -name 'sha*.txt' | xargs -n 1 sha1sum | sha1sum > ${BACKUP_CRC_FILE}

echo "validate" > ${UPGRADE_FLAG}
sync

exit 0
