#!/bin/sh
echo "DO_NOT_REBOOT"

TARGET_DIR=$"/media/service/unattached_deploy_log.txt"

if [ -d "/media/usbstorage/sda1/welbilt/" ]
then
TARGET_DIR=$"/media/usbstorage/sda1/welbilt/package/deploy_log.txt"
fi

if [ -d "/media/usbstorage/sda/welbilt/" ]
then
TARGET_DIR=$"/media/usbstorage/sda/welbilt/package/deploy_log.txt"
fi

{

echo "Deploying AWS Components..."
echo "Version 1.0"

echo "     Disabling existing services..."
#systemctl disable fq4000.service
systemctl disable fqlink-backup.service
systemctl disable fqlink.service
systemctl disable iotagent.service

echo "     Stopping up FQ4000..."
#systemctl stop fq4000.service
systemctl stop fqlink-backup.service
systemctl stop fqlink.service
systemctl stop iotagent.service

echo "     Setting up FQ4000..."
cp /opt/frymaster/deployToUI/ExeFiles/FQ4000/bin/* /opt/FQ4000/bin/

#remove all previus IoT Agents
rm -Rf /opt/fqlink/iotagent_*
rm -rf /opt/fqlink/can_app/config
rm -Rf /opt/fqlink/can_app/certs

echo "     Setting up CAN / IoTAgent App..."
cp /opt/frymaster/deployToUI/ExeFiles/fqlink /opt/ -rf
chmod +x /opt/fqlink/can_app/script/*.sh

echo "     Setting up services..."
cp /opt/frymaster/deployToUI/LibFiles/*.service /lib/systemd/system/

echo "     Setting up Dbus..."
cp /opt/frymaster/deployToUI/DbusFiles/*.conf /etc/dbus-1/system.d/

echo "     Setting up iotAgent..."
cp /opt/frymaster/deployToUI/IoTAppFiles/* /opt/fqlink/can_app/ -rf

echo "     Registering Service Scripts..."
#systemctl enable fq4000.service
systemctl enable fqlink-backup.service

sync 
echo 3 > /proc/sys/vm/drop_caches
sleep 3


echo "Done Deploying UI Components."
} > $TARGET_DIR 2>&1

sync
sleep 8

echo "DO_NOT_REBOOT"
#reboot

exit 0
