#!/bin/sh

ACTIVE_DIR=/opt/fqlink
BACKUP_DIR=/media/service/fqlink_backup
SERVICE_ACTIVE_DIR=/lib/systemd/system
SERVICE_BACKUP_DIR=${BACKUP_DIR}/service
UPGRADE_FLAG=${ACTIVE_DIR}/upgrade_status
CRC_FILE1=sha1.txt
CRC_FILE2=sha2.txt
BACKUP_CRC_FILE1=${BACKUP_DIR}/${CRC_FILE1}
BACKUP_CRC_FILE2=${BACKUP_DIR}/${CRC_FILE2}


if [ -f "${UPGRADE_FLAG}" ]; then
    STATUS=`cat ${UPGRADE_FLAG}`
    if [ "success" == ${STATUS} ]; then
        echo "FQLINK backup resotring is not required"
        exit 0
    fi
fi

if [ ! -f "${BACKUP_CRC_FILE1}" ]; then
    echo "ERROR: FQLINK backup is corrupted. Cannot restore."
    exit 1
fi

echo "Restore of FQLINK services from backup"

# Create active directory if it doesn't exist
if [ ! -d "${ACTIVE_DIR}" ]; then
    echo "FQLINK active folder '${ACTIVE_DIR}' is not present"
    mkdir ${ACTIVE_DIR}
fi

echo "Check CRC of backup files"
find ${BACKUP_DIR} -type f  -not -name 'sha*.txt' | xargs -n 1 sha1sum | sha1sum > ${BACKUP_CRC_FILE2}
cmp ${BACKUP_CRC_FILE1} ${BACKUP_CRC_FILE2}

if [[ $? -ne 0 ]] ; then
    echo "ERROR: FQLINK backup is corrupted. Cannot restore."
    exit 1
fi

echo "Cleanup previous active folder '${ACTIVE_DIR}'"
#rm -rf ${ACTIVE_DIR}/*

echo "Copy existing files from backup to active directory '${ACTIVE_DIR}'"
#copy service files
cp -R ${SERVICE_BACKUP_DIR}/* ${SERVICE_ACTIVE_DIR}/
#apply service changes
systemctl daemon-reload

rm -rf ${SERVICE_BACKUP_DIR}

#copy fqlink directory
cp -f -R ${BACKUP_DIR}/* ${ACTIVE_DIR}/
# and exclude runtime files
#rm -f ${BACKUP_DIR}/can_app/*.txt ${BACKUP_DIR}/can_app/*.db
echo "backup restored" > ${UPGRADE_FLAG}
sync

exit 0
