#!/bin/sh

RESTORE_SCRIPT=/opt/fqlink/can_app/script/restore_from_backup.sh
UPGRADE_FLAG=/opt/fqlink/upgrade_status
RESTART_FLAG=/opt/fqlink/need_restart

function validate_services {
    polling_count=5
    polling_interval=10s
    ret=0
    for (( i=0; i < $polling_count; i++ ))
    do
        echo "Run validate_services. Step 1"
        ret=0
        sleep 1s
        state1=`systemctl show -p ActiveState --value fqlink`
        state2=`systemctl show -p ActiveState --value iotagent`
        if [[ "active" != ${state1} || "active" != ${state2} ]]; then
            echo "Services validation error in step 1"
            echo "state1 = ${state1}"
            echo "state2 = ${state2}"
            ret=1
        else
            echo "Run validate_services. Step 2"
            sleep 10s
            state1=`systemctl show -p ActiveState --value fqlink`
            state2=`systemctl show -p ActiveState --value iotagent`
            if [[ "active" != ${state1} || "active" != ${state2} ]]; then
                echo "Services validation error in step 2"
                echo "state1 = ${state1}"
                echo "state2 = ${state2}"
                ret=2
            else
                echo "Run validate_services. Step 3"
                sync
                sleep 25s
                state1=`systemctl show -p SubState --value fqlink`
                state2=`systemctl show -p SubState --value iotagent`
                if [[ "running" != ${state1} || "running" != ${state2} ]]; then
                    echo "Services validation error in step 3"
                    echo "state1 = ${state1}"
                    echo "state2 = ${state2}"
                    ret=3
                fi
            fi
        fi

    if [[ "$ret" -eq 0 ]]; then
        break
    else
        sleep $polling_interval
    fi
    done

    sync
    return $ret
}

function restore_fqlink {
    echo "Stop FQLINK services"
    systemctl stop fqlink
    sleep 1s
    echo "Copying files from backup"
    ${RESTORE_SCRIPT}
    echo "restored" > ${UPGRADE_FLAG}
    sync
    echo "Restarting FQLINK services after restore from backup ..."
    systemctl reset-failed  iotagent
    systemctl reset-failed  fqlink
    systemctl start fqlink
    sleep 1s
    echo "`systemctl show -p ActiveState iotagent`"
    echo "`systemctl show -p ActiveState fqlink`"
}

# start background process to monitor the health of FQLINK services
printed_upgrade_status=""
echo "fqlink-backup service started"
while true
do
    if [ -f "${UPGRADE_FLAG}" ]; then
        upgrade_status=`cat ${UPGRADE_FLAG}`
        if [[ "${printed_upgrade_status}" != "${upgrade_status}" ]]; then
            printed_upgrade_status="${upgrade_status}"
            echo "Upgrade process status is '${upgrade_status}'"
        fi

        if [ "verifying" == ${upgrade_status} ]; then
            # FQLINK services were restarted to complete upgrade - check it
            echo "Functionality check required after restarting FQLINK services"
            validate_services
            services_fail=$?
            echo "validate_services returned ${services_fail}"
            if [[ $services_fail -ne 0 ]]; then
                echo "Need restore FQLINK services from backup"
                echo "failed" > ${UPGRADE_FLAG}
                restore_fqlink
            else
                echo "FQLINK strated successfully. Restoring is not required"
                echo "success" > ${UPGRADE_FLAG}
            fi
            sync
        else
            # Waiting upgrade actions
            # and check if restart is needed
            if [ -f "${RESTART_FLAG}" ]; then
                restart_status=`cat ${RESTART_FLAG}`
                echo "Upgrade process status is '${upgrade_status}'"
                echo "need_restart = '${restart_status}'"
                if [[ "need_restart" == "${restart_status}" ]]; then
                    rm -f ${RESTART_FLAG}
                    sync
                    echo "It is request to restart FQLINK services. Do it."
                    systemctl restart fqlink
                fi
           fi
        fi
    else
        if [[ "" != "${printed_upgrade_status}" ]]; then
            echo "No upgrade action"
            printed_upgrade_status=""
        fi
    fi

    sleep 2s
done

